<!DOCTYPE html>
<html lang="en">

<head>
    <title>JJ Royal Coffee | Admin</title>

    <!-- Meta -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="description" content="" />
    <meta name="keywords" content="">
    <meta name="author" content="Phoenixcoded" />
    <!-- Favicon icon -->
    <link rel="icon" href="<?php echo e(asset('asset/admin/images/favicon.ico')); ?>" type="image/x-icon">

    
    <script src="https://kit.fontawesome.com/fd31be6171.js" crossorigin="anonymous"></script>

    
    <link rel="stylesheet" href="https://cdn.datatables.net/2.0.1/css/dataTables.dataTables.css" />

    
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- vendor css -->
    <link rel="stylesheet" href="<?php echo e(asset('asset/admin/css/style.css')); ?>">

    <style>
        .select2-container--default .select2-selection--single {
            display: block;
            width: 100%;
            height: calc(1.5em + 1.25rem + 4px);
            padding: 0.625rem 1.1875rem;
            font-size: 0.875rem;
            font-weight: 400;
            line-height: 1.5;
            color: #495057;
            background-color: #fff;
            background-clip: padding-box;
            border: 2px solid rgba(0, 0, 0, 0.15);
            border-radius: 0;
            transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
            padding-top: 5px;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            margin-top: 5px;
        }

        .select2-container--default {
            width: 100% !important;
        }

        .select2-container .select2-selection--single .select2-selection__rendered {
            padding-left: 0px;
        }

        .select2-container--default .select2-selection {
            display: block;
            width: 100%;
            height: calc(1.5em + 1.25rem + 4px);
            padding: 0.625rem 1.1875rem;
            font-size: 0.875rem;
            font-weight: 400;
            line-height: 1.5;
            color: #495057;
            background-color: #fff;
            background-clip: padding-box;
            border: 2px solid rgba(0, 0, 0, 0.15);
            border-radius: 0;
            transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
            padding-top: 5px;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice__display {
            padding-left: 10px;
        }

        .select2-container .select2-selection--multiple .select2-selection__rendered {
            padding-left: 0;
        }
    </style>

    <?php echo $__env->yieldContent('css'); ?>

</head>

<body class="">
    <!-- [ Pre-loader ] start -->
    <div class="loader-bg">
        <div class="loader-track">
            <div class="loader-fill"></div>
        </div>
    </div>
    <!-- [ Pre-loader ] End -->
    <!-- [ navigation menu ] start -->
    <nav class="pcoded-navbar  ">
        <div class="navbar-wrapper  ">
            <div class="navbar-content scroll-div ">

                <div class="">
                    
                    <div class="collapse" id="nav-user-link">
                        <ul class="list-unstyled">
                            <li class="list-group-item"><a href="user-profile.html"><i
                                        class="feather icon-user m-r-5"></i>View Profile</a></li>
                            <li class="list-group-item"><a href="<?php echo e(route('logout')); ?>"
                                    onclick="event.preventDefault();
                                document.getElementById('logout-form').submit();"><i
                                        class="feather icon-log-out m-r-5"></i>Logout</a></li>

                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                <?php echo csrf_field(); ?>
                            </form>
                        </ul>
                    </div>
                </div>

                <ul class="nav pcoded-inner-navbar ">
                    <li class="nav-item pcoded-menu-caption">
                        <label>Navigation</label>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(url('home')); ?>" class="nav-link "><span class="pcoded-micon"><i
                                    class="feather icon-home"></i></span><span class="pcoded-mtext">Dashboard</span></a>
                    </li>

                    
                    <li class="nav-item pcoded-menu-caption">
                        <label>Master Data</label>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(url('admin/kopi')); ?>" class="nav-link "><span class="pcoded-micon">
                                <i class="fas fa-coffee"></i></span><span class="pcoded-mtext">Master Kopi</span></a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(url('admin/kuisioner')); ?>" class="nav-link "><span class="pcoded-micon">
                                <i class="fas fa-clipboard-list"></i></span><span class="pcoded-mtext">Master
                                Kuisioner</span></a>
                    </li>
                </ul>

            </div>
        </div>
    </nav>
    <!-- [ navigation menu ] end -->
    <!-- [ Header ] start -->
    <header class="navbar pcoded-header navbar-expand-lg navbar-light header-dark">


        <div class="m-header">
            <a class="mobile-menu" id="mobile-collapse" href="#!"><span></span></a>
            <a href="#!" class="b-brand">
                <!-- ========   change your logo hear   ============ -->
                <img src="<?php echo e(asset('asset/admin/images/logo.png')); ?>" class="mr-2" width="100%" alt=""
                    class="logo">
                
                
            </a>
            <a href="#!" class="mob-toggler">
                <i class="feather icon-more-vertical"></i>
            </a>
        </div>
        <div class="collapse navbar-collapse">
            <ul class="navbar-nav ml-auto">
                <li>
                    <div class="dropdown drp-user">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                            <i class="feather icon-user"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right profile-notification">
                            <div class="pro-head">
                                
                                <span><?php echo e(Auth::user()->name); ?></span>
                                <a href="<?php echo e(route('logout')); ?>"
                                    onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                                    class="dud-logout" title="Logout">
                                    <i class="feather icon-log-out"></i>
                                </a>
                            </div>
                            
                        </div>
                    </div>
                </li>
            </ul>
        </div>


    </header>
    <!-- [ Header ] end -->

    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">

            <?php echo $__env->yieldContent('body'); ?>

        </div>
    </div>
    <!-- [ Main Content ] end -->

    <!-- Required Js -->
    <script src="<?php echo e(asset('asset/admin/js/vendor-all.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/admin/js/plugins/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/admin/js/pcoded.js')); ?>"></script>

    
    <script src="https://cdn.datatables.net/2.0.1/js/dataTables.js"></script>

    
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    
    
    <script src="//cdn.ckeditor.com/4.6.2/full/ckeditor.js"></script>

    <script>
        function notifForum() {
            window.open(`<?php echo e(url('admin/forum?status=3')); ?>`, "_self");
        }

        $('.select2').each(function() {
            $(this).select2({
                dropdownParent: $(this).parent(), // fix select2 search input focus bug
            })
        });

        CKEDITOR.config.toolbar = [
            ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'Blockquote', 'CreateDiv', '-',
                'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock', '-', 'BidiLtr', 'BidiRtl'
            ],
            ['Cut', 'Copy', 'Paste', 'PasteText', '-', 'Undo', 'Redo', 'RemoveFormat'],
            ['Link', 'Unlink'],
            ['Source', '-', 'Maximize'], '/',
            ['Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', 'RemoveFormat'],
            ['TextColor', 'BGColor'],
            {
                name: 'insert',
                items: ['InsertCustomImage', 'Table', 'Iframe', 'HorizontalRule', 'Smiley', 'SpecialChar',
                    'PageBreak'
                ]
            }, '/',
            ['Styles', 'Format', 'Font', 'FontSize'],
        ];


        $.fn.modal.Constructor.prototype._enforceFocus = function() {
            // var $modalElement = this.$element;
            // $(document).on('focusin.modal', function(e) {
            //     if ($modalElement.length > 0 && $modalElement[0] !== e.target &&
            //         !$modalElement.has(e.target).length &&
            //         $(e.target).parentsUntil('*[role="dialog"]').length === 0) {
            //         $modalElement.focus();
            //     }
            // });
        };
    </script>

    <?php echo $__env->yieldContent('javascript'); ?>

</body>

</html>
<?php /**PATH C:\xampp\htdocs\jjroyal2\resources\views/layouts/admin.blade.php ENDPATH**/ ?>