<?php

namespace App\Http\Controllers;
use Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;

use App\Models\m_kopies;
use App\Models\m_kuisioners;
use App\Models\m_jawabans;

class kopiController extends Controller
{
    public function index()
    {
        $data = m_kopies::where('del',0)->get();

        return view('kopi', compact('data'));
    }

    public function store(Request $request)
    {
        $forms = $request->all();

        $validator = Validator::make($forms, [
            'name' => 'required',
            'file' => 'required',
        ]);

		if($validator->fails()){
            \Session::flash('alert', 'alert-danger');
			\Session::flash('message', 'Gagal, Data Tidak Lengkap');
		}else{

            if(isset($forms['file'])){
                $file = $request->file('file');
                $ekstensi = strtolower($file->getClientOriginalExtension());
                if ($ekstensi == 'png' || $ekstensi == 'jpg' || $ekstensi == 'jpeg') {
                    if ($file->getSize() <= 8000000) {
                        $tujuan = 'upload/kopi/';
                        $forms['file'] = $this->__GenerateRandomName().'_'.date('YmdHi').'.'.$ekstensi;
                        $file->move($tujuan,$forms['file']);
                        $forms['foto'] = $tujuan.'/'.$forms['file'];
                        m_kopies::create($forms);
                        \Session::flash('alert', 'alert-success');
                        \Session::flash('message', 'Berhasil, Data Tersimpan');
                    }else{
                        \Session::flash('alert', 'alert-danger');
                        \Session::flash('message', 'Maaf, Ukuran Dokumen Lebih Dari 8MB');
                    }
                }else{
                    \Session::flash('alert', 'alert-danger');
                    \Session::flash('message', 'Maaf, Dokumen Bukan Berformat pdf/image');
                }
            }else{
                \Session::flash('alert', 'alert-danger');
                \Session::flash('message', 'Gagal, Foto Tidak Ada');
            }

        }
        return redirect('admin/kopi');
    }

    public function show($id)
    {
        $id = Crypt::decrypt($id);
        $find = m_kopies::select('name')->find($id);
        return response()->json($find);
    }

    public function edit($id)
    {
        $idku = Crypt::decrypt($id);
        $find = m_kopies::find($idku);
        $find->crypt = $id;
        return response()->json($find);
    }

    public function update(Request $request, $id)
    {
        $id = Crypt::decrypt($id);
        $forms = $request->all();
        $validator = Validator::make($forms, [
            'edit_name' => 'required',
        ]);
        if($validator->fails()){
            \Session::flash('alert', 'alert-danger');
			\Session::flash('message', 'Gagal, Data Tidak Lengkap');
            return redirect('admin/kopi');
        }else{
            $find = m_kopies::find($id);

            if(isset($forms['edit_file'])){
                $file = $request->file('edit_file');
                $ekstensi = strtolower($file->getClientOriginalExtension());
                if ($ekstensi == 'png' || $ekstensi == 'jpg' || $ekstensi == 'jpeg') {
                    if ($file->getSize() <= 8000000) {
                        $tujuan = 'upload/kopi/';
                        $forms['file'] = $this->__GenerateRandomName().'_'.date('YmdHi').'.'.$ekstensi;
                        $file->move($tujuan,$forms['file']);
                        $forms['foto'] = $tujuan.'/'.$forms['file'];
                    }else{
                        \Session::flash('alert', 'alert-danger');
                        \Session::flash('message', 'Maaf, Ukuran Dokumen Lebih Dari 8MB');
                        return redirect('admin/kopi');
                    }
                }else{
                    \Session::flash('alert', 'alert-danger');
                    \Session::flash('message', 'Maaf, Dokumen Bukan Berformat pdf/image');
                    return redirect('admin/kopi');
                }
            }else{
                $forms['foto'] = $find->foto;
            }

            $ubah['name'] = $forms['edit_name'];
            $ubah['foto'] = $forms['foto'];

            // if($forms['l_toped'] != null && $forms['l_toped'] != ''){
            //     $ubah['l_toped'] = $forms['l_toped'];
            // }
            // if($forms['l_shopee'] != null && $forms['l_shopee'] != ''){
            //     $ubah['l_shopee'] = $forms['l_shopee'];
            // }
            // if($forms['l_tiktok'] != null && $forms['l_tiktok'] != ''){
            //     $ubah['l_tiktok'] = $forms['l_tiktok'];
            // }
            // if($forms['l_lazada'] != null && $forms['l_lazada'] != ''){
            //     $ubah['l_lazada'] = $forms['l_lazada'];
            // }
            // if($forms['l_bukalapak'] != null && $forms['l_bukalapak'] != ''){
            //     $ubah['l_bukalapak'] = $forms['l_bukalapak'];
            // }
            // if($forms['l_wa'] != null && $forms['l_wa'] != ''){
            //     $ubah['l_wa'] = $forms['l_wa'];
            // }

            $find->update($ubah);
            \Session::flash('alert', 'alert-success');
            \Session::flash('message', 'Berhasil, Data Telah Diupdate');
        }
        return redirect('admin/kopi');
    }

    public function destroy(Request $request, $id)
    {
        $id = Crypt::decrypt($id);
        $find = m_kopies::find($id);
        if (isset($find)) {
            $find->update([
                'del'=>'1'
            ]);
            \Session::flash('alert', 'alert-success');
            \Session::flash('message', 'Berhasil, Data Dihapus');
        }else{
            \Session::flash('alert', 'alert-warning');
			\Session::flash('message', 'Maaf, Data Tidak Ada');
        }
        return redirect('admin/kopi');
    }

}
