<?php

namespace App\Http\Controllers;

use Auth;
use Illuminate\Http\Request;
use App\Models\m_kopies;
use App\Models\m_kuisioners;
use App\Models\m_jawabans;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    public function home()
    {
        return view('mulai');
    }

    public function kuisioner(Request $request, $kuis)
    {
        $data = m_kuisioners::find($kuis);
        $data->jawaban = m_jawabans::where('del', 0)->where('jenis_id', $kuis)->orderBy('urutan', 'ASC')->get();
        $lanjutan = m_kuisioners::where('urutan', '=', $data->urutan + 1)->first();
        $forms = $request->all();
        $kuis_all = m_kuisioners::where('del',0)->orderBy('urutan','ASC')->get();
        return view('kuisioner', compact('forms', 'kuis', 'data', 'lanjutan','kuis_all'));
    }

    public function hasil(Request $request)
    {
        $forms = $request->all();
        $kopi = m_kopies::get();

        foreach ($kopi as $key => $d) {
            $d->hasil = 0;
        }

        foreach ($forms as $key => $d) {
            $cek = m_jawabans::find($d);
            $kkopi = explode(',', $cek->kopi);
            foreach ($kkopi as $kay => $kk) {
                foreach ($kopi as $kkk => $k) {
                    if ($kk == $kkk) {
                        $k->hasil = $k->hasil + 1;
                    }
                }
            }
        }
        $kopi = collect($kopi)->sortBy('hasil')->reverse()->toArray();

        return view('hasil', compact('forms', 'kopi'));
    }

    public function index()
    {
        $data = array();
        $user = array();
        return view('home', compact('data','user'));
    }
}
